IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Ped_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Cbtes_Ped_Generar 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Ped_Generar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans		TINYINT
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Usuario		SMALLINT
DECLARE @pId_Trans			INT
DECLARE @pLote				VARCHAR(20)
DECLARE @pFecha				DATETIME
DECLARE @pFechaVence		DATETIME
DECLARE @pId_Cliente		INT
DECLARE @pId_Tipo_Cbte		CHAR(4)
DECLARE @pId_Cond_Pago		SMALLINT
DECLARE @pId_Moneda			CHAR(3)
DECLARE @pCotizacion		DECIMAL(12,4)
DECLARE @pId_Contrato		INT
DECLARE @pNro_Auto_Trib		VARCHAR(14)
DECLARE @pCai_Vence			DATETIME
DECLARE @Bonif_Contrato     DECIMAL(5,2)
DECLARE @pId_Periodo_Caja	INT							--03/02/2021 Agregado
DECLARE @pImporte			DECIMAL(16,2)				--03/02/2021 Agregado
DECLARE @pId_Cobrador		VARCHAR(10)					--04/02/2021 Agregado
DECLARE @pCbte_Nro_Externo	VARCHAR(25)					--19/05/2021 Agregado
DECLARE @pId_Trans_Origen	INT							--19/05/2021 13:48 Agregado
DECLARE @pId_Estado_Proceso	SMALLINT					--21/05/2021 Agregado
DECLARE @pId_Dep_Fisico		CHAR(3)						--10/06/2021 Agregado
DECLARE @pId_Dep_Logico		CHAR(3)						--10/06/2021 Agregado
DECLARE @pObservacion		VARCHAR(8000)						--20/09/2021 Agregado

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), -1)
SET @pId_Trans				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pLote					= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Lote')), '')
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')),'19000101')
SET @pFechaVence			= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'FechaVence'))
SET @pId_Cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Tipo_Cbte			= ISNULL(CONVERT(CHAR(4), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Cbte')), '')
SET @pId_Cond_Pago			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Cond_Pago')), '')
SET @pId_Moneda				= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Moneda')), '')
SET @pCotizacion			= ISNULL(CONVERT(DECIMAL(12,4), dbo.CF_JSON_VALUE(@pJson,'Cotizacion')), 0)
SET @Bonif_Contrato			= ISNULL(CONVERT(DECIMAL(5,2), dbo.CF_JSON_VALUE(@pJson,'Bonif_Contrato')), 0)
SET @pId_Contrato			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Contrato')), 0)
SET @pNro_Auto_Trib			= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Nro_Auto_Trib')), '')
SET @pCai_Vence				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Cai_Vence')), '19000101')
SET @pId_Periodo_Caja		= ISNULL(CONVERT(INT,dbo.CF_JSON_VALUE(@pJson,'Id_Periodo_Caja')),0)
SET @pImporte				= ISNULL(CONVERT(DECIMAL(15,2), dbo.CF_JSON_VALUE(@pJson,'Importe')), 0)
SET @pId_Cobrador			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Cobrador')), '')
SET @pCbte_Nro_Externo		= ISNULL(CONVERT(VARCHAR(25), dbo.CF_JSON_VALUE(@pJson,'Cbte_Nro_Externo')), '')
SET @pId_Trans_Origen		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans_Origen')), 0)
SET @pId_Estado_Proceso		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Estado_Proceso')), 0)
SET @pId_Dep_Fisico			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Dep_Fisico')), '')
SET @pId_Dep_Logico			= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Dep_Logico')), '')
SET @pObservacion			= ISNULL(CONVERT(VARCHAR(8000), dbo.CF_JSON_VALUE(@pJson,'Observacion')), '')
/*FIN Variables recibidas por parametro a traves del JSON*/


/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Empresa			SMALLINT
DECLARE @Id_Sucursal		SMALLINT
DECLARE @Cbte_Grupo			INT
DECLARE @Comprobante_Nro	INT
DECLARE @Id_Taller			VARCHAR(10)
DECLARE @Id_Proceso			VARCHAR(10)
DECLARE @Id_Proveedor		INT
DECLARE @Signo				SMALLINT
DECLARE @Id_Estado_Cbte		SMALLINT
DECLARE @Id_Dep_Fisico		CHAR(3)
DECLARE @Id_Dep_Logico		CHAR(3)
DECLARE @Porc_DescEspecial	DECIMAL(5, 2)
DECLARE @Porc_DescFin		DECIMAL(5, 2)
DECLARE @Porc_Iva			DECIMAL(5, 2)
DECLARE @Porc_Iva2			DECIMAL(5, 2)
DECLARE @Imp_Neto			DECIMAL(12, 2)
DECLARE @Imp_DescEspecial	DECIMAL(12, 2)
DECLARE @Imp_DescFin		DECIMAL(12, 2)
DECLARE @Imp_Bonificacion	DECIMAL(12, 2)
DECLARE @Imp_Gravado		DECIMAL(12, 2)
DECLARE @Imp_Exento			DECIMAL(12, 2)
DECLARE @Imp_IVA			DECIMAL(12, 2)
DECLARE @Imp_IVA2			DECIMAL(12, 2)
DECLARE @Imp_Percepcion_IB	DECIMAL(12, 2)
DECLARE @Imp_Percepcion_Iva DECIMAL(12, 2)
DECLARE @Imp_Total			DECIMAL(12, 2)
DECLARE @Bultos				SMALLINT
DECLARE @NroImpresion		INT
DECLARE @Exportado			TINYINT
DECLARE @Dir_Entrega		VARCHAR(255)
DECLARE @Id_Pais			CHAR(3)
DECLARE @Id_Provincia		CHAR(3)
DECLARE @Id_Localidad		INT
DECLARE @Porc_Iva3			DECIMAL(5, 2)
DECLARE @Imp_Gravado2		DECIMAL(12, 2)
DECLARE @Imp_Gravado3		DECIMAL(12, 2)
DECLARE @Imp_NoGravado		DECIMAL(12, 2)
DECLARE @Imp_IVA3			DECIMAL(12, 2)
DECLARE @Imp_Percep			DECIMAL(12, 2)
DECLARE @Saldo				DECIMAL(12, 2)
DECLARE @Periodo_Iva		DATETIME
DECLARE @Periodo			DATETIME
DECLARE @Id_Cond_Pago_Item	TINYINT
DECLARE @Id_Tipo_Reten		VARCHAR(10)
DECLARE @Cant_Cuotas		SMALLINT
DECLARE @Id_Producto		VARCHAR(14)
DECLARE @Id_Formula			VARCHAR(15)
DECLARE @Cantidad			DECIMAL(12, 4)
DECLARE @Id_Transportista	INT
DECLARE @Destinatario		VARCHAR(100)
DECLARE @Cuit				VARCHAR(19)
DECLARE @Doc_Nro			BIGINT
DECLARE @Id_Iva				CHAR(3)
DECLARE @Cant_Batch			SMALLINT
DECLARE @Fecha_Perm_Embar	DATETIME
DECLARE @Saldo_Iva_Recup	DECIMAL(12, 2)
DECLARE @Suc_Destina		SMALLINT
DECLARE @Id_Asiento			INT
DECLARE @Id_Valor			INT
DECLARE @Cai				DECIMAL(14, 0)
DECLARE @Des_Anio			TINYINT
DECLARE @Des_Aduana			CHAR(3)
DECLARE @Des_Destina		CHAR(4)
DECLARE @Des_Nro			INT
DECLARE @Des_Verif			CHAR(1)
DECLARE @Id_Cobrador		VARCHAR(10)
DECLARE @Remito_Nro			VARCHAR(25)
DECLARE @Pedido_Nro			VARCHAR(25)
DECLARE @Id_Tarjeta			VARCHAR(11)
DECLARE @Tarjeta_Nro		VARCHAR(25)
DECLARE @Cantidad_Saldo		DECIMAL(12, 4)
DECLARE @Saldo_Anterior		DECIMAL(12, 2)
DECLARE @NRO_DJAI			VARCHAR(30)
DECLARE @Cantidad_Equiv		DECIMAL(12, 4)
DECLARE @Id_Trans_Origen	INT
DECLARE @Id_Sede_Origen		SMALLINT
DECLARE @Email				VARCHAR(8000)
DECLARE @Patente_Transporte VARCHAR(7)
DECLARE @Patente_Transporte_Acoplado VARCHAR(7)
DECLARE @Plazo_Venc			SMALLINT
DECLARE @Porc_Bonificacion	DECIMAL(5,2)
DECLARE @Fecha_Estimada		DATETIME
DECLARE @Persona_Recibe		VARCHAR(100)
DECLARE @Observacion		VARCHAR(8000)
DECLARE @Id_Lista			SMALLINT
DECLARE @Id_Lista_Contrato	SMALLINT
DECLARE @Id_Vendedor		VARCHAR(10)
DECLARE @Nro_Perm_Embarque	VARCHAR(20)
DECLARE @Id_Puerto			CHAR(3)
DECLARE @Id_Cond_Vta		CHAR(10)
DECLARE @Cbte_Nro_Externo	VARCHAR(25)
DECLARE @Nota_Part1			VARCHAR(100)
DECLARE @Nota_Part2			VARCHAR(100)
DECLARE @Id_Centro_Costo	CHAR(10)
DECLARE @Id_Camp			SMALLINT
DECLARE @Flag_Lote			TINYINT
DECLARE @Compromete_Factura SMALLINT
DECLARE @Descrip_Cbte		VARCHAR(100)
DECLARE @Importe			DECIMAL(12, 2)
DECLARE @Importe_Con_Signo	DECIMAL(12, 2)
DECLARE @Id_Cliente_Ref		INT
DECLARE @Renglon_Nro		SMALLINT
DECLARE @Id_Estado_Mov_Caja	INT
DECLARE @Descripcion		VARCHAR(100)
DECLARE @Id_Tipo_Mov_Caja	SMALLINT
DECLARE @Id_Concepto		INT
DECLARE @Item				SMALLINT
DECLARE @Id_Estado_Concepto	SMALLINT
DECLARE @Id_Estado_Proceso	SMALLINT

DECLARE @Id_Imp_Fiscal CHAR(1)
/*Fin de Declaraciones Variables Locales */



BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Ped_Generar'
		PRINT 'Parametros:'
		PRINT 'pFlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans)  + '. pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. pLote: ' + @pLote + '. pFecha: ' + CONVERT(VARCHAR(10), @pFecha, 103) + '. pFechaVence: ' + CONVERT(VARCHAR(10), @pFechaVence, 103) +  '. pId_Cliente: ' + CONVERT(VARCHAR(10), @pId_Cliente) + '. pId_Tipo_Cbte: ' + @pId_Tipo_Cbte + '. pId_Cond_Pago: ' + CONVERT(VARCHAR(10), @pId_Cond_Pago) + '. pId_Moneda: ' + @pId_Moneda + '. pCotizacion: ' + CONVERT(VARCHAR(10), @pCotizacion)
		PRINT 'pId_Contrato: ' + CONVERT(VARCHAR(10), @pId_Contrato)  + '. pNro_Auto_Trib: ' + @pNro_Auto_Trib + '. @pCai_Vence: ' + CONVERT(VARCHAR(10), @pCai_Vence, 103) + '. pId_Periodo_Caja: ' + CONVERT(VARCHAR(10), @pId_Periodo_Caja) + '. pImporte: ' + CONVERT(VARCHAR(10), @pImporte)
	END
	
	/*===================================================================*/


	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Inserta en Transacciones.'
	END
	
	IF(@pId_Trans = 0)
	BEGIN
		SET @pId_Trans		= ISNULL((SELECT MAX(Id_Trans) FROM Transacciones), 0) + 1
		INSERT INTO Transacciones 
		(Id_Trans,		Descripcion,						Fecha_Mov,
		Id_Usuario) 
		VALUES
		(@pId_Trans,	'Apertura CPJ_Transacciones_Abrir', GETDATE(), 
		@pId_Usuario)
	END


	/*===================================================================*/


	IF(@pId_Cliente = 0)  RAISERROR ('Id_Cliente can not be zero.', 16,  1 ) 
	IF(@pId_Tipo_Cbte = '') RAISERROR ('Id_Tipo_Cbte can not be blank.', 16,  1 ) 

		
	/*===================================================================*/
	
	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END
	
	IF(@pId_Moneda = '')
	BEGIN
		SET @pId_Moneda = dbo.CF_xParam('Moneda_Nacional')
	END

	IF(@pCotizacion = 0)
	BEGIN
		SET @pCotizacion = 1
	END
	
	IF(@pLote <> '')
	BEGIN
		SET @Flag_Lote	= 1
	END
	ELSE
	BEGIN
		SET @Flag_Lote	= 0
	END
	
	/*===================================================================*/

	SET @pFecha				= (SELECT CONVERT(DATE, @pFecha))
    SET @Id_Estado_Cbte		= 0  --siempre comienza en carga

	/*===================================================================*/

	SELECT  @Id_Sucursal		= ISNULL(Id_Sucursal, 0),
			@Cbte_Grupo			= ISNULL(Cbte_Grupo, 0),
			@Compromete_Factura = ISNULL(Compromete_Factura, 0)
	FROM Cbtes_Tipos 
	WHERE 
	Id_Tipo_Cbte = @pId_Tipo_Cbte
	
	/*===================================================================*/

	SELECT 	@Destinatario	= ISNULL(Razon_Social, Apellido + ', ' + Nombre),
			@Id_Pais		= ISNULL(Id_Pais_Cob, ''),
			@Id_Provincia	= ISNULL(Id_Provincia_Cob, ''),
			@Id_Localidad	= ISNULL(Id_Localidad_Cob, 0),
			@Cuit			= ISNULL(Cuit, ''),
			@Doc_Nro		= ISNULL(Doc_Nro, 0),
			@Id_Iva			= ISNULL(Id_Iva, ''),
			@Id_Dep_Fisico	= ISNULL(Id_Dep_Fisico, ''),
			@Id_Dep_Logico	= ISNULL(Id_Dep_Logico, ''),
			@Email			= ISNULL(Email, ''),
			@Id_Lista		= ISNULL(Id_Lista_Precio, 0),
			@Porc_Bonificacion = ISNULL(Bonif, 0),
			@Id_Cliente_Ref	= ISNULL(Id_Cliente_Ref, 0),
			@Id_Concepto	= ISNULL(Id_Concepto, 0)
	FROM Clientes
	WHERE
	Id_Cliente = @pId_Cliente

	--13/07/2021 Agregado
	SELECT
	@Id_Imp_Fiscal = ISNULL(Id_Imp_Fiscal, '')
	FROM Iva
	WHERE
	Id_Iva = @Id_Iva
	--FIN 13/07/2021 Agregado

	--10/06/2021 Agregado
	IF(@pId_Dep_Fisico <> '')
	BEGIN
		SET @Id_Dep_Fisico = @pId_Dep_Fisico
	END

	--10/06/2021 Agregado
	IF(@pId_Dep_Logico <> '')
	BEGIN
		SET @Id_Dep_Logico = @pId_Dep_Logico
	END

	--25/01/2021 Agregado 
	IF(@Id_Localidad = 0)
	BEGIN
		SET @Id_Provincia = ''
		SET @Id_Pais = ''
	END
	--FIN 25/01/2021 Agregado 

	--13/07/2021 Modificado - 04/05/2021	Agregado	
	IF(@Id_Imp_Fiscal = 'F' /*Consumidor Final*/)
	BEGIN
		SET @Cuit = 0
	END
	ELSE
	BEGIN
		IF ((@Cuit = '' OR @Cuit = '0') AND @Doc_Nro > 0)
		BEGIN
			SET @Cuit = CONVERT(VARCHAR(19), @Doc_Nro)
		END
	END
	--FIN 13/07/2021 Modificado - 04/05/2021	Agregado

	/*===================================================================*/
	IF @pId_Contrato <> 0
	BEGIN
		SELECT @Id_Lista_Contrato = Id_Lista_Precio FROM Contratos WHERE Id_Contrato = @pId_Contrato
		IF ISNULL(@Id_Lista_Contrato,0) <> 0 SET @Id_Lista = @Id_Lista_Contrato
	END
	IF @Bonif_Contrato <> 0
	   SET @Porc_Bonificacion = @Bonif_Contrato

	/*===================================================================*/

	SET @Comprobante_Nro	= 0 /*En Carga*/
	SET @Importe			= 0 /*En Carga*/
	SET @Importe_Con_Signo	= @Importe * @Compromete_Factura
	SET @Plazo_Venc			= ISNULL((SELECT ISNULL(Plazo_Venc, 0) FROM Cbtes_Cond_Pago WHERE Id_Cond_Pago = @pId_Cond_Pago), 0)
	SET @Periodo_Iva		= @pFecha
	SET @Periodo			= @pFecha
	SET @Imp_Total			= 0 /*Hay que actualizarlo luego de grabar los items*/
	SET @Saldo				= 0 /*Hay que actualizarlo luego de grabar los items*/
	SET @Imp_Gravado		= 0 /*Hay que actualizarlo luego de grabar los items*/
	SET @Imp_Neto			= 0 /*Hay que actualizarlo luego de grabar los items*/
	SET @Imp_Exento			= 0 /*Hay que actualizarlo luego de grabar los items*/
		
	/*TO-DO: De aca para abajo por ahora por Default*/
	SET @Id_Taller			= ''
	SET @Id_Proceso			= ''
	SET @Id_Proveedor		= 0
	SET @Signo				= 0
	SET	@Porc_DescFin		= 0
	SET @Porc_DescEspecial	= 0
	SET @Porc_Iva			= dbo.CF_xParam('Tasa_Iva_1')
	SET @Porc_Iva2			= dbo.CF_xParam('Tasa_Iva_2')
	SET @Imp_DescEspecial	= 0
	SET @Imp_DescFin		= 0
	SET @Imp_Bonificacion	= 0
	SET @Imp_Iva			= 0
	SET @Imp_Iva2			= 0
	SET @Imp_Percepcion_IB	= 0
	SET @Imp_Percepcion_Iva = 0
	SET @Bultos				= 0
	SET @NroImpresion		= 0
	SET @Exportado			= 0
	SET @Dir_Entrega		= ''
	SET @Porc_Iva3			= dbo.CF_xParam('Tasa_Iva_3')
	SET @Imp_Gravado2		= 0
	SET @Imp_Gravado3		= 0
	SET @Imp_NoGravado		= 0
	SET @Imp_IVA3			= 0
	SET @Imp_Percep			= 0
	SET @Id_Cond_Pago_Item	= 0
	SET @Id_Tipo_Reten		= ''
	SET @Cant_Cuotas		= 1
	SET @Id_Producto		= NULL
	SET @Id_Formula			= NULL
	SET @Cantidad			= 0
	SET @Id_Transportista	= 0
	SET @Cant_Batch			= 0
	SET @Fecha_Perm_Embar	= NULL
	SET @Saldo_Iva_Recup	= 0
	SET @Suc_Destina		= 0
	SET @Id_Asiento			= 0
	SET @Id_Valor			= 0
	SET @Cai				= 0	
	SET @Des_Anio			= 0
	SET @Des_Aduana			= ''
	SET @Des_Destina		= ''
	SET @Des_Nro			= 0
	SET @Des_Verif			= ''
	
	IF(@pId_Cobrador <> '')
	BEGIN
		SET @Id_Cobrador		= @pId_Cobrador
	END
	ELSE
	BEGIN
		SET @Id_Cobrador		= (SELECT ISNULL(Id_Cobrador, '') FROM Clientes WHERE Id_Cliente = @pId_Cliente)
	END

	SET @Remito_Nro			= ''
	SET @Pedido_Nro			= ''
	SET @Id_Tarjeta			= ''
	SET @Tarjeta_Nro		= ''
	SET @Cantidad_Saldo		= 0
	SET @Saldo_Anterior		= 0
	SET @NRO_DJAI			= ''
	SET @Cantidad_Equiv		= 0
	SET @Id_Trans_Origen	= @pId_Trans_Origen
	SET @Id_Sede_Origen		= 0
	SET @Patente_Transporte = ''
	SET @Patente_Transporte_Acoplado = ''
	SET @Porc_Bonificacion	= 0
	SET @Fecha_Estimada		= NULL
	SET @Persona_Recibe		= ''
	SET @Id_Vendedor		= ''
	SET @Nro_Perm_Embarque	= ''
	SET @Id_Puerto			= ''
	SET @Id_Cond_Vta		= ''
	SET @Cbte_Nro_Externo	= @pCbte_Nro_Externo
	SET @Nota_Part1			= ''
	SET @Nota_Part2			= ''
	SET @Id_Centro_Costo	= ''
	SET @Id_Camp			= 0
	SET @Id_Estado_Proceso	= @pId_Estado_Proceso

	
	INSERT INTO Cbtes
	(Id_Trans,			Id_Empresa,			Id_Sucursal,
	Id_Tipo_Cbte,		Cbte_Grupo,			Comprobante_Nro,
	Id_Cliente,			Id_Taller,			Id_Proceso,
	Id_Proveedor,		Signo,				Id_Estado_Cbte,
	Fecha,				Id_Dep_Fisico,		Id_Dep_Logico,
	Porc_DescEspecial,	Porc_DescFin,		Porc_Bonificacion,
	Porc_Iva,			Porc_Iva2,			Imp_Neto,
	Imp_DescEspecial,	Imp_DescFin,		Imp_Bonificacion,
	Imp_Gravado,		Imp_Exento,			Imp_IVA,
	Imp_IVA2,			Imp_Percepcion_IB,	Imp_Percepcion_Iva,
	Imp_Total,			Bultos,				NroImpresion,
	Exportado,			Id_Usuario,			Fecha_Estimada,
	Dir_Entrega,		Id_Pais,			Id_Provincia,
	Id_Localidad,		Persona_Recibe,		Porc_Iva3,
	Imp_Gravado2,		Imp_Gravado3,		Imp_NoGravado,
	Imp_IVA3,			Imp_Percep,			Saldo,
	Periodo_Iva,		Periodo,			Fecha_Venc,
	Observacion,		Id_Cond_Pago_Item,	Id_Cond_Pago,
	Id_Tipo_Reten,		Cant_Cuotas,		Id_Producto,
	Id_Formula,			Cantidad,			Id_Vendedor,
	Id_Transportista,	Id_Lista,			Id_Moneda,
	Cotizacion,			Destinatario,		Cuit,
	Id_Iva,				Cant_Batch,			Nro_Perm_Embarque,
	Fecha_Perm_Embar,	Saldo_Iva_Recup,	Lote,
	Suc_Destina,		Id_Puerto,			Id_Cond_Vta,
	Cbte_Nro_Externo,	Nota_Part1,			Nota_Part2,
	Id_Asiento,			Id_Centro_Costo,	Id_Valor,
	Cai,				Cai_Vence,			Des_Anio,
	Des_Aduana,			Des_Destina,		Des_Nro,
	Des_Verif,			Id_Contrato,		Id_Cobrador,
	Nro_Auto_Trib,		Id_Camp,			Remito_Nro,
	Pedido_Nro,			Id_Tarjeta,			Tarjeta_Nro,
	Cantidad_Saldo,		Saldo_Anterior,		NRO_DJAI,
	Cantidad_Equiv,		Id_Trans_Origen,	Id_Sede_Origen,
	Email,				Patente_Transporte,	Patente_Transporte_Acoplado,
	Flag_Lote,			Id_Cliente_Ref,		Id_Estado_Proceso)
	VALUES
	(@pId_Trans,		@Id_Empresa,		@Id_Sucursal,
	@pId_Tipo_Cbte,		@Cbte_Grupo,		@Comprobante_Nro,
	@pId_Cliente,		@Id_Taller,			@Id_Proceso,
	@Id_Proveedor,		@Signo,				@Id_Estado_Cbte,
	@pFecha,			@Id_Dep_Fisico,		@Id_Dep_Logico,
	@Porc_DescEspecial,	@Porc_DescFin,		@Porc_Bonificacion,
	@Porc_Iva,			@Porc_Iva2,			@Imp_Neto,
	@Imp_DescEspecial,	@Imp_DescFin,		@Imp_Bonificacion,
	@Imp_Gravado,		@Imp_Exento,		@Imp_IVA,
	@Imp_IVA2,			@Imp_Percepcion_IB,	@Imp_Percepcion_Iva,
	@Imp_Total,			@Bultos,			@NroImpresion,
	@Exportado,			@pId_Usuario,		@Fecha_Estimada,
	@Dir_Entrega,		@Id_Pais,			@Id_Provincia,
	@Id_Localidad,		@Persona_Recibe,	@Porc_Iva3,
	@Imp_Gravado2,		@Imp_Gravado3,		@Imp_NoGravado,
	@Imp_IVA3,			@Imp_Percep,		@Saldo,
	@Periodo_Iva,		@Periodo,			@pFechaVence,
	@pObservacion,		@Id_Cond_Pago_Item,	@pId_Cond_Pago,
	@Id_Tipo_Reten,		@Cant_Cuotas,		@Id_Producto,
	@Id_Formula,		@Cantidad,			@Id_Vendedor,
	@Id_Transportista,	@Id_Lista,			@pId_Moneda,
	@pCotizacion,		@Destinatario,		@Cuit,
	@Id_Iva,			@Cant_Batch,		@Nro_Perm_Embarque,
	@Fecha_Perm_Embar,	@Saldo_Iva_Recup,	@pLote,
	@Suc_Destina,		@Id_Puerto,			@Id_Cond_Vta,
	@Cbte_Nro_Externo,	@Nota_Part1,		@Nota_Part2,
	@Id_Asiento,		@Id_Centro_Costo,	@Id_Valor,
	@Cai,				@pCai_Vence,		@Des_Anio,
	@Des_Aduana,		@Des_Destina,		@Des_Nro,
	@Des_Verif,			@pId_Contrato,		@Id_Cobrador,
	@pNro_Auto_Trib,	@Id_Camp,			@Remito_Nro,
	@Pedido_Nro,		@Id_Tarjeta,		@Tarjeta_Nro,
	@Cantidad_Saldo,	@Saldo_Anterior,	@Nro_DJAI,
	@Cantidad_Equiv,	@Id_Trans_Origen,	@Id_Sede_Origen,
	@Email,				@Patente_Transporte,@Patente_Transporte_Acoplado,
	@Flag_Lote,			@Id_Cliente_Ref,	@Id_Estado_Proceso)

	/*===================================================================*/
	
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	/*===================================================================*/	
	
	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT')  + ',' +
								dbo.CF_Json_ParsearVariable('id_cliente', @pId_Cliente, 'INT')  + ',' +
								dbo.CF_Json_ParsearVariable('id_tipo_cbte', @pId_Tipo_Cbte, 'VARCHAR') +
								'}'
								
	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@pId_Trans		AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Ped_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0
